/*
 * Decompiled with CFR 0.152.
 */
package org.metagnostic.jniport.test.regression;

import org.metagnostic.jniport.DolphinRequest;
import org.metagnostic.jniport.RequestNotHandedException;

public class Callbacks {
    private static final Object s_callback0Tag = new String("Callbacks.callback0()");
    private static final Object s_callback1Tag = new String("Callbacks.callback1()");
    private static final Object s_callback2Tag = new String("Callbacks.callback2()");
    private static final Object s_failingCallbackTag = new String("Callbacks.callbackThatFails()");
    private static final Object s_errorCallbackTag = new String("Callbacks.callbackThatFailsWithError()");

    public static Object callback0Tag() {
        return s_callback0Tag;
    }

    public static Object callback1Tag() {
        return s_callback1Tag;
    }

    public static Object callback2Tag() {
        return s_callback2Tag;
    }

    public static Object failingCallbackTag() {
        return s_failingCallbackTag;
    }

    public static Object errorCallbackTag() {
        return s_errorCallbackTag;
    }

    void callback() throws Throwable {
        new DolphinRequest(s_callback0Tag, (Object)this).value();
    }

    int callback(int n) throws Throwable {
        Object object = new DolphinRequest(s_callback1Tag, (Object)this, n).value();
        return (Integer)object;
    }

    void callback(int n, double d) throws Throwable {
        DolphinRequest dolphinRequest = new DolphinRequest(s_callback2Tag, (Object)this, (Object)new Integer(n), (Object)new Double(d));
        dolphinRequest.value();
    }

    void callbackThatFails() throws Throwable {
        new DolphinRequest(s_failingCallbackTag, (Object)this).value();
    }

    void callbackThatFailsWithError() throws Throwable {
        new DolphinRequest(s_errorCallbackTag, (Object)this).value();
    }

    public void callbackInLine() throws Throwable {
        this.callback();
    }

    public void callbackInBackground(int n, int n2) {
        class Backgrounder
        implements Runnable {
            private final /* synthetic */ int val$times;
            private final /* synthetic */ int val$sleep;

            Backgrounder(int n, int n2) {
                this.val$times = n;
                this.val$sleep = n2;
            }

            public void run() {
                for (int i = 0; i < this.val$times; ++i) {
                    try {
                        Thread.sleep(this.val$sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        Callbacks.this.callback();
                        continue;
                    }
                    catch (Throwable throwable) {
                        return;
                    }
                }
            }
        }
        new Thread(new Backgrounder(n, n2)).start();
    }

    public void callback0() throws Throwable {
        this.callback();
    }

    public void callback1() throws Throwable {
        this.callback(1);
    }

    public void callback2() throws Throwable {
        this.callback(1, 2.0);
    }

    public int callbackAndReturn(int n) throws Throwable {
        return this.callback(n);
    }

    public boolean callbackAndThrowNPE() {
        try {
            this.callbackThatFails();
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean callbackAndThrowOther() {
        try {
            this.callbackThatFailsWithError();
        }
        catch (RequestNotHandedException requestNotHandedException) {
            return true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

