/*
 * Decompiled with CFR 0.152.
 */
package org.metagnostic.jniport.test.regression;

import org.metagnostic.jniport.DolphinNotification;
import org.metagnostic.jniport.RequestNotHandedException;

public class Notifications {
    private static final Object s_notify0Tag = new String("Notifications.sendNotification0()");
    private static final Object s_notify1Tag = new String("Notifications.sendNotification1()");
    private static final Object s_notify2Tag = new String("Notifications.sendNotification2()");
    private static final Object s_failingNotifyTag = new String("Notifications.sendNotificationThatFails()");
    private static final Object s_errorNotifyTag = new String("Notifications.sendNotificationThatFailsWithError()");

    public static Object notify0Tag() {
        return s_notify0Tag;
    }

    public static Object notify1Tag() {
        return s_notify1Tag;
    }

    public static Object notify2Tag() {
        return s_notify2Tag;
    }

    public static Object failingNotifyTag() {
        return s_failingNotifyTag;
    }

    public static Object errorNotifyTag() {
        return s_errorNotifyTag;
    }

    void sendNotification() throws RequestNotHandedException {
        new DolphinNotification(s_notify0Tag, (Object)this).send();
    }

    void sendNotification(int n) throws RequestNotHandedException {
        new DolphinNotification(s_notify1Tag, (Object)this, n).send();
    }

    void sendNotification(int n, double d) throws RequestNotHandedException {
        new DolphinNotification(s_notify2Tag, (Object)this, (Object)new Integer(n), (Object)new Double(d)).send();
    }

    void sendNotificationThatFails() throws RequestNotHandedException {
        new DolphinNotification(s_failingNotifyTag, (Object)this).send();
    }

    void sendNotificationThatFailsWithError() throws RequestNotHandedException {
        new DolphinNotification(s_errorNotifyTag, (Object)this).send();
    }

    public void notifyInLine() throws Throwable {
        this.sendNotification();
    }

    public void notifyInBackground(int n, int n2) {
        class Backgrounder
        implements Runnable {
            private final /* synthetic */ int val$times;
            private final /* synthetic */ int val$sleep;

            Backgrounder(int n, int n2) {
                this.val$times = n;
                this.val$sleep = n2;
            }

            public void run() {
                for (int i = 0; i < this.val$times; ++i) {
                    try {
                        Thread.sleep(this.val$sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        Notifications.this.sendNotification();
                        continue;
                    }
                    catch (Throwable throwable) {
                        return;
                    }
                }
            }
        }
        new Thread(new Backgrounder(n, n2)).start();
    }

    public void notify0() throws RequestNotHandedException {
        this.sendNotification();
    }

    public void notify1() throws RequestNotHandedException {
        this.sendNotification(1);
    }

    public void notify2() throws RequestNotHandedException {
        this.sendNotification(1, 2.0);
    }

    public void notifyAndThrowNPE() throws RequestNotHandedException {
        this.sendNotificationThatFails();
    }

    public void notifyAndThrowOther() throws RequestNotHandedException {
        this.sendNotificationThatFailsWithError();
    }
}

