/*
 * Decompiled with CFR 0.152.
 */
package org.metagnostic.jniport;

import org.metagnostic.jniport.DolphinNotifierThread;
import org.metagnostic.jniport.DolphinRequestQueue;
import org.metagnostic.jniport.RequestNotHandedException;

public abstract class AbstractDolphinRequest {
    private final Object m_tag;
    private final Object m_originator;
    private final Object m_parameter;
    private boolean m_isStarted = false;
    AbstractDolphinRequest m_next;

    protected AbstractDolphinRequest(Object object, Object object2, Object object3) {
        if (object == null) {
            throw new NullPointerException("tag must not be null)");
        }
        this.m_tag = object;
        this.m_originator = object2;
        this.m_parameter = object3;
    }

    protected AbstractDolphinRequest(Object object, Object object2) {
        this(object, object2, null);
    }

    public Object getTag() {
        return this.m_tag;
    }

    public Object getOriginator() {
        return this.m_originator;
    }

    public Object getParameter() {
        return this.m_parameter;
    }

    public synchronized boolean isStarted() {
        return this.m_isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue() throws RequestNotHandedException {
        this.log("Request: enqueue()");
        DolphinNotifierThread dolphinNotifierThread = DolphinNotifierThread.getDemon();
        if (dolphinNotifierThread == null) {
            throw new RequestNotHandedException("Dolphin is not listening");
        }
        AbstractDolphinRequest abstractDolphinRequest = this;
        synchronized (abstractDolphinRequest) {
            if (this.m_isStarted) {
                return;
            }
            this.m_isStarted = true;
            DolphinRequestQueue.enqueue(this);
        }
        dolphinNotifierThread.notifyDolphin();
    }

    public boolean isNotificationOnly() {
        return true;
    }

    void notifyCompleted(Object object, Throwable throwable) {
    }

    void notifyIgnored() {
        this.notifyCompleted(null, new RequestNotHandedException());
    }

    void notifyIgnored(String string) {
        this.notifyCompleted(null, new RequestNotHandedException(string));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("(tag: ");
        stringBuffer.append(this.m_tag);
        if (this.m_originator != null) {
            stringBuffer.append(", orig: ");
            stringBuffer.append(this.m_originator);
        }
        if (this.m_parameter != null) {
            stringBuffer.append(", param: ");
            stringBuffer.append(this.m_parameter);
        }
        if (this.m_isStarted) {
            stringBuffer.append(", started");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected void log(String string) {
        DolphinRequestQueue.log(string, this);
    }
}

