/*
 * Decompiled with CFR 0.152.
 */
package org.metagnostic.jniport;

import org.metagnostic.jniport.DolphinRequestQueue;

class DolphinNotifierThread
extends Thread {
    private static DolphinNotifierThread s_demon;
    private boolean m_serviceRequested;
    private boolean m_shutdownRequested;
    private int m_callbackDepth;
    private final Thread m_dolphinNativeThread;

    public static synchronized DolphinNotifierThread getDemon() {
        return s_demon;
    }

    private static synchronized void setDolphinNativeThread() {
        s_demon = new DolphinNotifierThread(DolphinNotifierThread.currentThread());
    }

    static synchronized void shutdown() {
        DolphinRequestQueue.log("Demon: shutdown()");
        if (s_demon != null) {
            s_demon.requestShutdown();
        }
        s_demon = null;
    }

    private DolphinNotifierThread(Thread thread) {
        super("Dolphin notifier");
        this.setDaemon(true);
        this.m_dolphinNativeThread = thread;
        this.m_callbackDepth = 0;
        this.m_serviceRequested = false;
        this.m_shutdownRequested = false;
    }

    public void notifyDolphin() {
        DolphinNotifierThread.log("Demon: notifyDolphin()");
        if (this.runningInDolphinThread()) {
            this.servicePendingRequests();
        } else {
            this.sendServiceRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void servicePendingRequests() {
        DolphinNotifierThread.log("Demon: servicePendingRequests()");
        if (DolphinRequestQueue.queueHasBeenEmptied()) {
            DolphinNotifierThread.log("Demon: dolphinNotifierMethod() -- not needed");
            return;
        }
        DolphinNotifierThread dolphinNotifierThread = this;
        synchronized (dolphinNotifierThread) {
            ++this.m_callbackDepth;
        }
        DolphinNotifierThread.log("Demon: dolphinNotifierMethod() -- calling");
        DolphinNotifierThread.dolphinNotifierMethod();
        DolphinNotifierThread.log("Demon: dolphinNotifierMethod() -- returned");
        dolphinNotifierThread = this;
        synchronized (dolphinNotifierThread) {
            if (--this.m_callbackDepth < 1) {
                this.notifyAll();
            }
        }
        DolphinNotifierThread.log("Demon: servicePendingRequests() -- returned");
    }

    private synchronized void sendServiceRequest() {
        DolphinNotifierThread.log("Demon: sendServiceRequest()");
        if (!this.isAlive()) {
            DolphinNotifierThread.log("Demon: starting demon");
            this.start();
        }
        DolphinNotifierThread.log("Demon: prodding demon");
        this.m_serviceRequested = true;
        this.notifyAll();
    }

    private synchronized void requestShutdown() {
        DolphinNotifierThread.log("Demon: requestShutdown()");
        DolphinNotifierThread.log("Demon: prodding demon");
        this.m_shutdownRequested = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DolphinNotifierThread.log("Demon loop: starting");
        while (true) {
            DolphinNotifierThread dolphinNotifierThread = this;
            synchronized (dolphinNotifierThread) {
                while (!(this.m_shutdownRequested || this.m_serviceRequested && this.m_callbackDepth < 1)) {
                    try {
                        DolphinNotifierThread.log("Demon loop: sleeping");
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    DolphinNotifierThread.log("Demon loop: woken");
                }
                if (this.m_shutdownRequested) {
                    DolphinNotifierThread.log("Demon loop: shutdown requested");
                    return;
                }
                this.m_serviceRequested = false;
            }
            if (DolphinRequestQueue.queueHasBeenEmptied()) {
                DolphinNotifierThread.log("Demon loop: dolphinNotifierMethod() -- not needed");
                continue;
            }
            DolphinNotifierThread.log("Demon loop: dolphinNotifierMethod() -- calling");
            DolphinNotifierThread.dolphinNotifierMethod();
            DolphinNotifierThread.log("Demon loop: dolphinNotifierMethod() -- returned");
        }
    }

    public boolean runningInDolphinThread() {
        return DolphinNotifierThread.currentThread() == this.m_dolphinNativeThread;
    }

    private static native void dolphinNotifierMethod();

    private static void log(String string) {
        DolphinRequestQueue.log(string);
    }

    public String toString() {
        return this.getName() + ", service requested:" + this.m_serviceRequested + ", callback depth:" + this.m_callbackDepth;
    }
}

