/*
 * Decompiled with CFR 0.152.
 */
package org.metagnostic.jniport;

import org.metagnostic.jniport.AbstractDolphinRequest;
import org.metagnostic.jniport.RequestNotHandedException;

public class DolphinRequest
extends AbstractDolphinRequest {
    private boolean m_isComplete;
    private Object m_returnValue;
    private Throwable m_thrown;

    public DolphinRequest(Object object, Object object2, Object object3) {
        super(object, object2, object3);
    }

    public DolphinRequest(Object object, Object object2) {
        super(object, object2);
    }

    public DolphinRequest(Object object, Object object2, boolean bl) {
        this(object, object2, new Boolean(bl));
    }

    public DolphinRequest(Object object, Object object2, int n) {
        this(object, object2, new Integer(n));
    }

    public DolphinRequest(Object object, Object object2, double d) {
        this(object, object2, new Double(d));
    }

    public DolphinRequest(Object object, Object object2, float f) {
        this(object, object2, new Float(f));
    }

    public DolphinRequest(Object object, Object object2, Object object3, Object object4) {
        this(object, object2, new Object[]{object3, object4});
    }

    public DolphinRequest(Object object, Object object2, Object object3, Object object4, Object object5) {
        this(object, object2, new Object[]{object3, object4, object5});
    }

    public DolphinRequest(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this(object, object2, new Object[]{object3, object4, object5, object6});
    }

    public boolean isNotificationOnly() {
        return false;
    }

    public boolean checkForException() {
        return this.getException() != null;
    }

    public void startEvaluation() {
        try {
            this.enqueue();
        }
        catch (RequestNotHandedException requestNotHandedException) {
            this.notifyCompleted(null, requestNotHandedException);
        }
    }

    public Throwable getException() {
        this.startEvaluation();
        this.waitForResponse();
        return this.m_thrown;
    }

    public Object getReturnValue() {
        this.startEvaluation();
        this.waitForResponse();
        return this.m_returnValue;
    }

    public Object value() throws Throwable, RequestNotHandedException {
        this.startEvaluation();
        this.waitForResponse();
        if (this.m_thrown != null) {
            throw this.m_thrown;
        }
        return this.m_returnValue;
    }

    public synchronized boolean isComplete() {
        return this.m_isComplete;
    }

    public synchronized void waitForResponse() {
        this.log("Request: waitForResponse()");
        while (!this.m_isComplete) {
            try {
                this.log("Request: waitForResponse() -- sleeping");
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.log("Request: waitForResponse() -- waking");
        }
        this.log("Request: waitForResponse() -- returning");
    }

    synchronized void notifyCompleted(Object object, Throwable throwable) {
        this.m_isComplete = true;
        this.m_returnValue = object;
        this.m_thrown = throwable;
        this.log("Request: notifyCompleted()");
        this.notifyAll();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.m_isComplete) {
            if (this.m_thrown != null) {
                stringBuffer.append(" threw: ");
                stringBuffer.append(this.m_thrown);
            } else {
                stringBuffer.append(" returned: ");
                stringBuffer.append(this.m_returnValue);
            }
        }
        return stringBuffer.toString();
    }
}

