/*
 * Decompiled with CFR 0.152.
 */
package org.metagnostic.jniport;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.metagnostic.jniport.AbstractDolphinRequest;
import org.metagnostic.jniport.DolphinNotifierThread;

public abstract class DolphinRequestQueue {
    private static AbstractDolphinRequest s_requestQueue;
    private static AbstractDolphinRequest s_requestQueueTail;
    private static int s_requestQueueLength;
    private static int s_requestQueueMax;
    private static long s_requestsCompleted;
    private static boolean s_requestQueueFushed;
    private static volatile PrintStream s_logTo;

    public static synchronized int requestQueueLength() {
        return s_requestQueueLength;
    }

    public static synchronized int requestQueueMax() {
        return s_requestQueueMax;
    }

    public static synchronized long requestsCompleted() {
        return s_requestsCompleted;
    }

    static synchronized boolean queueHasBeenEmptied() {
        return s_requestQueueFushed;
    }

    public static void log(String string, AbstractDolphinRequest abstractDolphinRequest) {
        PrintStream printStream = s_logTo;
        if (printStream == null) {
            return;
        }
        String string2 = "" + Thread.currentThread() + "\n\t" + string + "\n\treq: " + abstractDolphinRequest;
        printStream.println(string2);
        printStream.flush();
    }

    public static void log(String string) {
        PrintStream printStream = s_logTo;
        if (printStream == null) {
            return;
        }
        String string2 = "" + Thread.currentThread() + "\n\t" + string;
        printStream.println(string2);
        printStream.flush();
    }

    public static void startLogging(String string) throws FileNotFoundException {
        DolphinRequestQueue.startLogging(new PrintStream(new FileOutputStream(string)));
    }

    public static void startLogging(PrintStream printStream) {
        s_logTo = printStream;
    }

    public static void stopLogging() {
        s_logTo = null;
    }

    public static synchronized void shutdown() {
        AbstractDolphinRequest abstractDolphinRequest;
        DolphinRequestQueue.log("Queue: shutdown()");
        DolphinNotifierThread.shutdown();
        DolphinRequestQueue.log("Queue: failing pending requests");
        while ((abstractDolphinRequest = DolphinRequestQueue.dequeue()) != null) {
            abstractDolphinRequest.notifyIgnored("Dolphin has stopped listening");
        }
    }

    static synchronized void enqueue(AbstractDolphinRequest abstractDolphinRequest) {
        DolphinRequestQueue.log("Queue: enqueue()", abstractDolphinRequest);
        if (s_requestQueue == null) {
            s_requestQueue = s_requestQueueTail = abstractDolphinRequest;
        } else {
            DolphinRequestQueue.s_requestQueueTail.m_next = abstractDolphinRequest;
            s_requestQueueTail = abstractDolphinRequest;
        }
        if (++s_requestQueueLength > s_requestQueueMax) {
            s_requestQueueMax = s_requestQueueLength;
        }
        s_requestQueueFushed = false;
    }

    private static synchronized AbstractDolphinRequest dequeue() {
        if (s_requestQueue == null) {
            DolphinRequestQueue.log("Queue: dequeue() -- empty queue");
            s_requestQueueFushed = true;
            return null;
        }
        AbstractDolphinRequest abstractDolphinRequest = s_requestQueue;
        s_requestQueue = DolphinRequestQueue.s_requestQueue.m_next;
        abstractDolphinRequest.m_next = null;
        if (abstractDolphinRequest == s_requestQueueTail) {
            s_requestQueueTail = null;
        }
        --s_requestQueueLength;
        ++s_requestsCompleted;
        DolphinRequestQueue.log("Queue: dequeue()", abstractDolphinRequest);
        return abstractDolphinRequest;
    }

    private static synchronized AbstractDolphinRequest[] dequeue(int n) {
        if (s_requestQueue == null) {
            DolphinRequestQueue.log("Queue: dequeue() -- empty queue");
            s_requestQueueFushed = true;
            return null;
        }
        AbstractDolphinRequest[] abstractDolphinRequestArray = new AbstractDolphinRequest[n > s_requestQueueLength ? s_requestQueueLength : n];
        for (int i = 0; i < abstractDolphinRequestArray.length; ++i) {
            AbstractDolphinRequest abstractDolphinRequest = abstractDolphinRequestArray[i] = s_requestQueue;
            s_requestQueue = DolphinRequestQueue.s_requestQueue.m_next;
            abstractDolphinRequest.m_next = null;
            if (abstractDolphinRequest != s_requestQueueTail) continue;
            s_requestQueueTail = null;
        }
        s_requestQueueLength -= abstractDolphinRequestArray.length;
        s_requestsCompleted += (long)abstractDolphinRequestArray.length;
        DolphinRequestQueue.log("Queue: dequeue(" + n + ") -> " + abstractDolphinRequestArray.length);
        return abstractDolphinRequestArray;
    }

    static {
        s_requestQueueLength = 0;
        s_requestQueueMax = 0;
        s_requestsCompleted = 0L;
        s_requestQueueFushed = false;
        s_logTo = null;
    }
}

