/*
 * Decompiled with CFR 0.152.
 */
package org.metagnostic.jniport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventObject;
import org.metagnostic.jniport.DolphinNotification;
import org.metagnostic.jniport.DolphinRequest;
import org.metagnostic.jniport.InvocationForwarder;
import org.metagnostic.jniport.RequestNotHandedException;

public class EventForwarder
extends InvocationForwarder
implements InvocationHandler {
    private final Method m_method;
    private boolean m_isAsynchronous;

    public EventForwarder(Method method, boolean bl) {
        this.m_method = method;
        this.m_isAsynchronous = bl;
    }

    public EventForwarder(Method method) {
        this(method, true);
    }

    protected Object invokeOther(Object object, Method method, Object[] objectArray) throws Throwable {
        if (!method.equals(this.m_method)) {
            return null;
        }
        EventObject eventObject = (EventObject)objectArray[0];
        Object object2 = eventObject.getSource();
        try {
            if (this.m_isAsynchronous) {
                new DolphinNotification((Object)this.m_method, object2, eventObject).send();
                return null;
            }
            return new DolphinRequest((Object)this.m_method, object2, eventObject).value();
        }
        catch (RequestNotHandedException requestNotHandedException) {
            System.err.println(requestNotHandedException);
            return null;
        }
    }

    public static Object forwarderFor(Method method, boolean bl) {
        return Proxy.newProxyInstance(method.getDeclaringClass().getClassLoader(), new Class[]{method.getDeclaringClass()}, (InvocationHandler)new EventForwarder(method, bl));
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.m_method;
    }
}

