/*
 * Decompiled with CFR 0.152.
 */
package org.metagnostic.jniport;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.metagnostic.jniport.DolphinNotification;
import org.metagnostic.jniport.RequestNotHandedException;

public class JavaToDolphinOutputStream
extends OutputStream {
    private static final String s_writeTag = new String("JavaToDolphinOutputStream.write()");
    private static final String s_closeTag = new String("JavaToDolphinOutputStream.close()");
    private static int s_hookedOut;
    private static int s_hookedErr;
    private static PrintStream s_oldOut;
    private static PrintStream s_oldErr;
    private static JavaToDolphinOutputStream s_newOut;
    private static JavaToDolphinOutputStream s_newErr;

    public static synchronized JavaToDolphinOutputStream installAsSystemOut() {
        if (s_hookedOut == 0) {
            s_newOut = new JavaToDolphinOutputStream();
            s_oldOut = System.out;
            System.setOut(new PrintStream(s_newOut));
        }
        ++s_hookedOut;
        return s_newOut;
    }

    public static synchronized void removeAsSystemOut() throws IOException {
        if (s_hookedOut < 1) {
            return;
        }
        if (--s_hookedOut == 0) {
            System.setOut(s_oldOut);
            s_newOut.closeNoThrow();
            s_newOut = null;
            s_oldOut = null;
        }
    }

    public static synchronized boolean isInstalledAsSystemOut() {
        return s_hookedOut > 0;
    }

    public static JavaToDolphinOutputStream installAsSystemErr() {
        if (s_hookedErr == 0) {
            s_newErr = new JavaToDolphinOutputStream();
            s_oldErr = System.err;
            System.setErr(new PrintStream(s_newErr));
        }
        ++s_hookedErr;
        return s_newErr;
    }

    public static synchronized void removeAsSystemErr() throws IOException {
        if (s_hookedErr < 1) {
            return;
        }
        if (--s_hookedErr == 0) {
            System.setErr(s_oldErr);
            s_newErr.closeNoThrow();
            s_newErr = null;
            s_oldErr = null;
        }
    }

    public static synchronized boolean isInstalledAsSystemErr() {
        return s_hookedErr > 0;
    }

    public static Object writeTag() {
        return s_writeTag;
    }

    public static Object closeTag() {
        return s_closeTag;
    }

    public void close() throws IOException {
        try {
            new DolphinNotification(s_closeTag, this).send();
        }
        catch (RequestNotHandedException requestNotHandedException) {
            throw new IOException(requestNotHandedException.getMessage());
        }
        finally {
            super.close();
        }
    }

    public void closeNoThrow() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray) throws IOException {
        try {
            new DolphinNotification((Object)s_writeTag, (Object)this, byArray).send();
        }
        catch (RequestNotHandedException requestNotHandedException) {
            throw new IOException(requestNotHandedException.getMessage());
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n != 0 || n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            byArray = byArray2;
        }
        this.write(byArray);
    }
}

