package org.metagnostic.jniport.test.regression;

import org.metagnostic.jniport.*;


/**
 * Java class for JNIPort regression tests.
 *<p>
 * Copyright &copy; 2003 and ongoing by Chris Uppal.
 *<p>
 * @author Chris Uppal (chris.uppal@metagnostic.org)
 */
public class Callbacks
{
	private static final Object
			s_callback0Tag = new String("Callbacks.callback0()"),
			s_callback1Tag = new String("Callbacks.callback1()"),
			s_callback2Tag = new String("Callbacks.callback2()"),
			s_failingCallbackTag = new String("Callbacks.callbackThatFails()"),
			s_errorCallbackTag = new String("Callbacks.callbackThatFailsWithError()");
	

	public static Object callback0Tag() { return s_callback0Tag; }
	public static Object callback1Tag() { return s_callback1Tag; }
	public static Object callback2Tag() { return s_callback2Tag; }
	public static Object failingCallbackTag() { return s_failingCallbackTag; }
	public static Object errorCallbackTag() { return s_errorCallbackTag; }


	void
	callback()
	throws Throwable
	{
		new DolphinRequest(s_callback0Tag, this).value();
	}

	int
	callback(int i)
	throws Throwable
	{
		Object retval = new DolphinRequest(s_callback1Tag, this, i).value();
		return ((Integer)retval).intValue();
	}


	void
	callback(int i, double d)
	throws Throwable
	{
		DolphinRequest dr;
		dr = new DolphinRequest(
					s_callback2Tag,
					this,
					new Integer(i),
					new Double(d));
		dr.value();
	}

	void
	callbackThatFails()
	throws Throwable
	{
		new DolphinRequest(s_failingCallbackTag, this).value();
	}

	void
	callbackThatFailsWithError()
	throws Throwable
	{
		new DolphinRequest(s_errorCallbackTag, this).value();
	}


	// callbacks from Dolphin thread
	public void
	callbackInLine()
	throws Throwable
	{
		callback();
	}


	// callbacks from other threads
	public void
	callbackInBackground(final int times, final int sleep)
	{
		class Backgrounder
		implements Runnable
		{
			public void
			run()
			{
				for (int i = 0; i < times; i++)
				{
					try
					{
						Thread.sleep(sleep);
					}
					catch (InterruptedException e)
					{
					}
					try
					{
						callback();
					}
					catch (Throwable t)
					{
						return;
					}
				}
			}
		}
		
		new Thread(new Backgrounder()).start();
	}


	// callbacks with no parameters
	public void
	callback0()
	throws Throwable
	{
		callback();
	}


	// callbacks with 1 parameter
	public void
	callback1()
	throws Throwable
	{
		callback(1);
	}


	// callbacks with >1 parameters
	public void
	callback2()
	throws Throwable
	{
		callback(1, 2.0);
	}


	// callbacks with return values
	public int
	callbackAndReturn(int i)
	throws Throwable
	{
		return callback(i);
	}
	
	
	// callbacks that throw Java exceptions
	public boolean
	callbackAndThrowNPE()
	{
		try
		{
			callbackThatFails();
		}
		catch (NullPointerException e)
		{
			return true;
		}
		catch (Throwable e)
		{
		}
		
		return false;
	}


	// callbacks that throw ST exceptions
	public boolean
	callbackAndThrowOther()
	{
		try
		{
			callbackThatFailsWithError();
		}
		catch (RequestNotHandedException e)
		{
			return true;
		}
		catch (Throwable e)
		{
		}
		
		return false;
	}
}
