package org.metagnostic.jniport.test.regression;

import java.lang.reflect.Method;


/**
 * Events.java
 *<p>
 * Copyright &copy; 2003 and ongoing by Chris Uppal.
 *<p>
 * @author Chris Uppal (chris.uppal@metagnostic.org)
 */
public class Events
{
	private static TestEventSource s_source;

	public static TestEventSource
	getEventSource()
	{
		// NB: create a new one each time
		return s_source = new TestEventSource();
	}

	// return the event (i.e. the java.lang.reflect.Method) that we
	// are going to test
	public static Method
	getEventMethod()
	throws NoSuchMethodException
	{
			return TestEventListener.class.
						getDeclaredMethod(
								"onTestEvent",
								new Class[] { TestEventObject.class });
	}

	// trigger sent from Dolphin thread
	public static void
	triggerInLine()
	{
		s_source.triggerTestEvent("inline");
	}

	// triggers sent from other threads
	public static void
	triggerInBackground(final int times, final int sleep)
	{
		class Backgrounder
		implements Runnable
		{
			public void
			run()
			{
				for (int i = 0; i < times; i++)
				{
					try
					{
						Thread.sleep(sleep);
					}
					catch (InterruptedException e)
					{
					}
					try
					{
						s_source.triggerTestEvent("background");
					}
					catch (Throwable t)
					{
						return;
					}
				}
			}
		}
		
		new Thread(new Backgrounder()).start();
	}


	public static void
	main(String[] args)
	{
		TestEventListener listener =
				new TestEventListener()
				{
					public void
					onTestEvent(TestEventObject event)
					{
						System.out.println(event);
					}
				};

		getEventSource().addListener(listener);

		triggerInBackground(3, 1000);
		try
		{
			Thread.sleep(5000);
		}
		catch (InterruptedException e)
		{
		}

		triggerInLine();
	}
}
