package org.metagnostic.jniport.test.regression;

/**
 * Java class for JNIPort regression tests.
 *<p>
 * Copyright &copy; 2002 and ongoing by Chris Uppal.
 *<p>
 * @author Chris Uppal (chris.uppal@metagnostic.org)
 */
public class HidingFields
extends  InheritedFieldsBase
implements InheritedFieldsInterface
{
	// these should hide the superclass fields
	public int			intField = 6;
	public static int	staticIntField = 666;

	// this should hide the interface fields
	public static final int	interfaceIntField = 66;


	public static void
	main(String[] args)
	{
		new HidingFields().test();
	}

	public void
	test()
	{
		System.out.println("intField = " + intField);
		System.out.println("staticIntField = " + staticIntField);
		System.out.println("interfaceIntField = " + interfaceIntField);
		System.out.println("staticBooleanField = " + staticBooleanField);

		// can't call this from Java because of the ambiguity, but
		// JNIPort has to cope at runtime
		//System.out.println("ambiguousIntField = " + ambiguousIntField);
	}
}
