package org.metagnostic.jniport.test.regression;

/**
 * Java class for JNIPort regression tests.
 *<p>
 * Copyright &copy; 2002 and ongoing by Chris Uppal.
 *<p>
 * @author Chris Uppal (chris.uppal@metagnostic.org)
 */
public class HidingMethods
extends InheritedMethodsBase
implements InheritedMethodsInterface
{
	// this should override the superclass method
	public int			intMethod() { return 6; }

	// this should implement the superclass method
	public int			abstractIntMethod() { return 66; }

	// this should hide the superclass method
	public static int	staticIntMethod() { return 666; }

	// this should implement the interface method
	public int			interfaceIntMethod() { return 6666; }


	public static void
	main(String[] args)
	{
		new HidingMethods().test();
	}

	public void
	test()
	{
		System.out.println("intMethod() = " + intMethod());
		System.out.println("abstractIntMethod() = " + abstractIntMethod());
		System.out.println("staticIntMethod() = " + staticIntMethod());
		System.out.println("interfaceIntMethod() = " + interfaceIntMethod());
		System.out.println("staticBooleanMethod() = " + staticBooleanMethod());
	}
}
