package org.metagnostic.jniport.test.regression;

/**
 * Java class for JNIPort regression tests.
 *<p>
 * Copyright &copy; 2002 and ongoing by Chris Uppal.
 *<p>
 * @author Chris Uppal (chris.uppal@metagnostic.org)
 */
public class InstanceFields
{
	public boolean booleanField = true;
	public boolean isBooleanTrue()	{ return booleanField == true; }
	public boolean isBooleanFalse()	{ return booleanField == false; }

	public char charField = '!';
	public boolean isCharZero()		{ return charField == '\0'; }
	public boolean isCharM()		{ return charField == 'M'; }
	public boolean isChar0xA()		{ return charField == '\n'; }
	public boolean isChar0xAA()		{ return charField == '\u00AA'; }
	public boolean isChar0xAAA()	{ return charField == '\u0AAA'; }
	public boolean isChar0xAAAA()	{ return charField == '\uAAAA'; }

	public byte byteField = 22;
	public boolean isByteZero()		{ return byteField == 0; }
	public boolean isByte33()		{ return byteField == 33; }
	public boolean isByteMinus33()	{ return byteField == -33; }

	public short shortField = 22;
	public boolean isShortZero()	{ return shortField == 0; }
	public boolean isShort33()		{ return shortField == 33; }
	public boolean isShortMinus33()	{ return shortField == -33; }

	public int intField = 22;
	public boolean isIntZero()		{ return intField == 0; }
	public boolean isInt33()		{ return intField == 33; }
	public boolean isIntMinus33()	{ return intField == -33; }

	public long longField = 22;
	public boolean isLongZero()		{ return longField == 0; }
	public boolean isLong33()		{ return longField == 33L; }
	public boolean isLongMinus33()	{ return longField == -33L; }

	public float floatField = 22;
	public boolean isFloatZero()	{ return floatField == 0; }
	public boolean isFloat33()		{ return floatField == 33.0F; }
	public boolean isFloatMinus33()	{ return floatField == -33.0F; }

	public double doubleField = 22;
	public boolean isDoubleZero()	{ return doubleField == 0; }
	public boolean isDouble33()		{ return doubleField == 33.0D; }
	public boolean isDoubleMinus33(){ return doubleField == -33.0D; }

	public java.awt.Point pointField = new java.awt.Point(3, 4);
	public boolean isPointNull()	{ return pointField == null; }
	public boolean isPointZero()	{ return pointField.x == 0 && pointField.y == 0; }
	public boolean isPoint33x45()	{ return pointField.x == 33 && pointField.y == 45; }

	public String stringField = "Hi there";
	public boolean isStringNull()	{ return stringField == null; }
	public boolean isStringEmpty()	{ return stringField.length() == 0; }
	public boolean isString33()		{ return stringField.equals("33"); }
}
