package org.metagnostic.jniport.test.regression;

import org.metagnostic.jniport.*;


/**
 * Java class for JNIPort regression tests.
 *<p>
 * Copyright &copy; 2003 and ongoing by Chris Uppal.
 *<p>
 * @author Chris Uppal (chris.uppal@metagnostic.org)
 */
public class Notifications
{
	private static final Object
		s_notify0Tag = new String("Notifications.sendNotification0()"),
		s_notify1Tag = new String("Notifications.sendNotification1()"),
		s_notify2Tag = new String("Notifications.sendNotification2()"),
		s_failingNotifyTag = new String("Notifications.sendNotificationThatFails()"),
		s_errorNotifyTag = new String("Notifications.sendNotificationThatFailsWithError()");
	
	public static Object notify0Tag() { return s_notify0Tag; }
	public static Object notify1Tag() { return s_notify1Tag; }
	public static Object notify2Tag() { return s_notify2Tag; }
	public static Object failingNotifyTag() { return s_failingNotifyTag; }
	public static Object errorNotifyTag() { return s_errorNotifyTag; }


	void
	sendNotification()
	throws RequestNotHandedException
	{
		new DolphinNotification(s_notify0Tag, this).send();
	}


	void
	sendNotification(int i)
	throws RequestNotHandedException
	{
		new DolphinNotification(s_notify1Tag, this, i).send();
	}


	void
	sendNotification(int i, double d)
	throws RequestNotHandedException
	{
		new DolphinNotification(
					s_notify2Tag,
					this,
					new Integer(i),
					new Double(d)).send();
	}


	void
	sendNotificationThatFails()
	throws RequestNotHandedException
	{
		new DolphinNotification(s_failingNotifyTag, this).send();
	}


	void
	sendNotificationThatFailsWithError()
	throws RequestNotHandedException
	{
		new DolphinNotification(s_errorNotifyTag, this).send();
	}


	// notifications sent from Dolphin thread
	public void
	notifyInLine()
	throws Throwable
	{
		sendNotification();
	}


	// notifications sent from other threads
	public void
	notifyInBackground(final int times, final int sleep)
	{
		class Backgrounder
		implements Runnable
		{
			public void
			run()
			{
				for (int i = 0; i < times; i++)
				{
					try
					{
						Thread.sleep(sleep);
					}
					catch (InterruptedException e)
					{
					}
					try
					{
						sendNotification();
					}
					catch (Throwable t)
					{
						return;
					}
				}
			}
		}
		
		new Thread(new Backgrounder()).start();
	}


	// notifications with no parameters
	public void
	notify0()
	throws RequestNotHandedException
	{
		sendNotification();
	}


	// notifications with 1 parameter
	public void
	notify1()
	throws RequestNotHandedException
	{
		sendNotification(1);
	}


	// notifications with >1 parameters
	public void
	notify2()
	throws RequestNotHandedException
	{
		sendNotification(1, 2.0);
	}


	// notifications that throw Java exceptions
	public void
	notifyAndThrowNPE()
	throws RequestNotHandedException
	{
		// we shouldn't ever hear of any problems
		sendNotificationThatFails();
	}


	// notifications that throw ST exceptions
	public void
	notifyAndThrowOther()
	throws RequestNotHandedException
	{
		// we shouldn't ever hear of any problems
		sendNotificationThatFailsWithError();
	}
}
