package org.metagnostic.jniport.test.regression;

/**
 * Java class for JNIPort regression tests.
 *<p>
 * Copyright &copy; 2002 and ongoing by Chris Uppal.
 *<p>
 * @author Chris Uppal (chris.uppal@metagnostic.org)
 */
public class StaticFields
{
	public static boolean booleanField = true;
	public static boolean isBooleanTrue()	{ return booleanField == true; }
	public static boolean isBooleanFalse()	{ return booleanField == false; }

	public static char charField = '!';
	public static boolean isCharZero()		{ return charField == '\0'; }
	public static boolean isCharM()			{ return charField == 'M'; }
	public static boolean isChar0xA()		{ return charField == '\n'; }
	public static boolean isChar0xAA()		{ return charField == '\u00AA'; }
	public static boolean isChar0xAAA()		{ return charField == '\u0AAA'; }
	public static boolean isChar0xAAAA()	{ return charField == '\uAAAA'; }

	public static byte byteField = 22;
	public static boolean isByteZero()		{ return byteField == 0; }
	public static boolean isByte33()		{ return byteField == 33; }
	public static boolean isByteMinus33()	{ return byteField == -33; }

	public static short shortField = 22;
	public static boolean isShortZero()		{ return shortField == 0; }
	public static boolean isShort33()		{ return shortField == 33; }
	public static boolean isShortMinus33()	{ return shortField == -33; }

	public static int intField = 22;
	public static boolean isIntZero()		{ return intField == 0; }
	public static boolean isInt33()			{ return intField == 33; }
	public static boolean isIntMinus33()	{ return intField == -33; }

	public static long longField = 22;
	public static boolean isLongZero()		{ return longField == 0; }
	public static boolean isLong33()		{ return longField == 33L; }
	public static boolean isLongMinus33()	{ return longField == -33L; }

	public static float floatField = 22;
	public static boolean isFloatZero()		{ return floatField == 0; }
	public static boolean isFloat33()		{ return floatField == 33.0F; }
	public static boolean isFloatMinus33()	{ return floatField == -33.0F; }

	public static double doubleField = 22;
	public static boolean isDoubleZero()	{ return doubleField == 0; }
	public static boolean isDouble33()		{ return doubleField == 33.0D; }
	public static boolean isDoubleMinus33()	{ return doubleField == -33.0D; }

	public static java.awt.Point pointField = new java.awt.Point(3, 4);
	public static boolean isPointNull()		{ return pointField == null; }
	public static boolean isPointZero()		{ return pointField.x == 0 && pointField.y == 0; }
	public static boolean isPoint33x45()	{ return pointField.x == 33 && pointField.y == 45; }

	public static String stringField = "Hi there";
	public static boolean isStringNull()	{ return stringField == null; }
	public static boolean isStringEmpty()	{ return stringField.length() == 0; }
	public static boolean isString33()		{ return stringField.equals("33"); }
}
