package org.metagnostic.jniport.test.regression;

import java.util.*;

/**
 * TestEventSource.java
 *<p>
 * Copyright &copy; 2003 and ongoing by Chris Uppal.
 *<p>
 * @author Chris Uppal (chris.uppal@metagnostic.org)
 */
public class TestEventSource
{
	List m_listeners = new ArrayList();
	

	public void
	addListener(TestEventListener listener)
	{
		m_listeners.add(listener);
	}
	

	public void
	removeListener(TestEventListener listener)
	{
		m_listeners.remove(listener);
	}
	

	public void
	triggerTestEvent(String text)
	{
		TestEventObject event = new TestEventObject(this, text);
		Iterator itr = m_listeners.iterator();
		while (itr.hasNext())
		{
			TestEventListener listener = (TestEventListener)itr.next();
			listener.onTestEvent(event);
		}
	}
}
