package org.metagnostic.jniport;

import java.lang.reflect.*;


/**
 * This class exists <em>only</em> to get around a problem calling
 * java.lang.Class.declaredMethods() (and similar) when running on
 * BEA JRockit 7 (and probably 8).  The class is deprecated at birth
 * and will go away as soon as BEA release a version of JRockit that
 * doesn't have the bug.
 *<p>
 * Copyright &copy; 2002 and ongoing by Chris Uppal.
 *<p>
 * @author Chris Uppal (chris.uppal@metagnostic.org)
 */
public class JRockitPatch
{
	/**
	 * @see java.lang.Class.getDeclaredClasses
	 */
	public static Class[]
	getDeclaredClasses(Class clazz)
	{
		return clazz.getDeclaredClasses();
	}


	/**
	 * @see java.lang.Class.getConstructor
	 */
	public static Constructor
	getDeclaredConstructor(Class clazz, Class[] parameterTypes)
	throws NoSuchMethodException
	{
		return clazz.getDeclaredConstructor(parameterTypes);
	}


	/**
	 * @see java.lang.Class.getConstructors
	 */
	public static Constructor[]
	getDeclaredConstructors(Class clazz)
	{
		return clazz.getDeclaredConstructors();
	}


	/**
	 * @see java.lang.Class.getDeclaredField
	 */
	public static Field
	getDeclaredField(Class clazz, String name)
	throws NoSuchFieldException
	{
		return clazz.getDeclaredField(name);
	}


	/**
	 * @see java.lang.Class.getDeclaredFields
	 */
	public static Field[]
	getDeclaredFields(Class clazz)
	{
		return clazz.getDeclaredFields();
	}


	/**
	 * @see java.lang.Class.getDeclaredMethod
	 */
	public static Method
	getDeclaredMethod(Class clazz, String name, Class[] parameterTypes)
	throws NoSuchMethodException
	{
		return clazz.getDeclaredMethod(name, parameterTypes);
	}


	/**
	 * @see java.lang.Class.getDeclaredMethods
	 */
	public static Method[]
	getDeclaredMethods(Class clazz)
	{
		return clazz.getDeclaredMethods();
	}


	/**
	 * @see java.lang.Class.getClasses
	 */
	public static Class[]
	getClasses(Class clazz)
	{
		return clazz.getClasses();
	}


	/**
	 * @see java.lang.Class.getConstructor
	 */
	public static Constructor
	getConstructor(Class clazz, Class[] parameterTypes)
	throws NoSuchMethodException
	{
		return clazz.getConstructor(parameterTypes);
	}


	/**
	 * @see java.lang.Class.getConstructors
	 */
	public static Constructor[]
	getConstructors(Class clazz)
	{
		return clazz.getConstructors();
	}


	/**
	 * @see java.lang.Class.getField
	 */
	public static Field
	getField(Class clazz, String name)
	throws NoSuchFieldException
	{
		return clazz.getField(name);
	}


	/**
	 * @see java.lang.Class.getFields
	 */
	public static Field[]
	getFields(Class clazz)
	{
		return clazz.getFields();
	}


	/**
	 * @see java.lang.Class.getMethod
	 */
	public static Method
	getMethod(Class clazz, String name, Class[] parameterTypes)
	throws NoSuchMethodException
	{
		return clazz.getMethod(name, parameterTypes);
	}


	/**
	 * @see java.lang.Class.getMethods
	 */
	public static Method[]
	getMethods(Class clazz)
	{
		return clazz.getMethods();
	}


	// getInterfaces() works so we don't need to mess with that too
}
