package org.metagnostic.jniport;

/**
 * Exception thrown when Dolphin has seen a request but found no handler
 * for it
 *<p>
 * Copyright &copy; 2002 and ongoing by Chris Uppal.
 *<p>
 * @author Chris Uppal (chris.uppal@metagnostic.org)
 */
public class RequestNotHandedException
extends RuntimeException
{
	/**
	 * Constructor for RequestNotHandedException.
	 */
	public RequestNotHandedException()
	{
		this("No handler was found for this request");
	}

	/**
	 * Constructor for RequestNotHandedException.
	 * @param message	A String describing the problem.
	 */
	public RequestNotHandedException(String message)
	{
		super(message);
	}
}
